/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.behaviour.furniture;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import technology.rocketjump.undermount.assets.entities.furniture.model.DoorState;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.components.SteeringComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.PhysicalEntityComponent;
import technology.rocketjump.undermount.entities.model.physical.furniture.DoorStateComponent;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class AutoAnimatedDoorBehaviour
implements BehaviourComponent {
    private Entity parentEntity;
    public static final float ANIMATION_TIME = 0.4f;
    private float currentStateElapsedTime = 0.0f;

    @Override
    public void init(Entity parentEntity, MessageDispatcher messageDispatcher, TiledMap areaMap) {
        this.parentEntity = parentEntity;
    }

    @Override
    public AutoAnimatedDoorBehaviour clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        AutoAnimatedDoorBehaviour cloned = new AutoAnimatedDoorBehaviour();
        cloned.init(this.parentEntity, messageDispatcher, tiledMap);
        return cloned;
    }

    @Override
    public void update(float deltaTime, TiledMap areaMap) {
        this.currentStateElapsedTime += deltaTime;
        DoorStateComponent doorStateComponent = this.parentEntity.getOrCreateComponent(DoorStateComponent.class);
        PhysicalEntityComponent physicalEntityComponent = this.parentEntity.getPhysicalEntityComponent();
        float currentAnimationProgress = physicalEntityComponent.getAnimationProgress();
        switch (doorStateComponent.getState()) {
            case CLOSED: {
                if (!(this.currentStateElapsedTime > 1.0f)) break;
                this.switchState(DoorState.OPENING, doorStateComponent);
                break;
            }
            case OPENING: {
                currentAnimationProgress += deltaTime / 0.4f;
                if (currentAnimationProgress >= 1.0f) {
                    currentAnimationProgress = 1.0f;
                    this.switchState(DoorState.OPEN, doorStateComponent);
                }
                physicalEntityComponent.setAnimationProgress(currentAnimationProgress);
                break;
            }
            case OPEN: {
                if (!(this.currentStateElapsedTime > 1.0f)) break;
                this.switchState(DoorState.CLOSING, doorStateComponent);
                break;
            }
            case CLOSING: {
                currentAnimationProgress -= deltaTime / 0.4f;
                if (currentAnimationProgress <= 0.0f) {
                    currentAnimationProgress = 0.0f;
                    this.switchState(DoorState.CLOSED, doorStateComponent);
                }
                physicalEntityComponent.setAnimationProgress(currentAnimationProgress);
            }
        }
    }

    private void switchState(DoorState newState, DoorStateComponent doorStateComponent) {
        doorStateComponent.setState(newState);
        this.currentStateElapsedTime = 0.0f;
    }

    @Override
    public void infrequentUpdate(GameContext gameContext) {
    }

    @Override
    public SteeringComponent getSteeringComponent() {
        return null;
    }

    @Override
    public boolean isUpdateEveryFrame() {
        return true;
    }

    @Override
    public boolean isUpdateInfrequently() {
        return false;
    }

    @Override
    public boolean isJobAssignable() {
        return false;
    }
}

